/*
 * InterruptEffectInfo.h
 *
 * Created 9/9/2009 By Johnny Huynh
 *
 * Version 00.00.01 9/9/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef INTERRUPT_EFFECT_INFO_H
 #define INTERRUPT_EFFECT_INFO_H
 
 template <typename T> class InterruptEffectInfo;
 
 #include "global.h"
 
 #include "collisionEntry.h"
 #include "EffectInfo.h"
 #include "EffectTask.h"
 #include "pointerTo.h"
 
 /**
  * Class specification for InterruptEffectInfo
  */
 template <typename T>
 class InterruptEffectInfo : public EffectInfo<T>
 {
 // Protected Static Functions
 protected:
    static inline void process_interrupt_effect( EffectInfo<T>* effect_info_Ptr, Object<T>* into_object_Ptr, const CollisionEntry& c_entry );
 
 // Data Members
 private:
    
 // Local Functions
 public:
    InterruptEffectInfo( EffectFunc* effect_func = &InterruptEffectInfo<T>::process_interrupt_effect );
    InterruptEffectInfo( const InterruptEffectInfo<T>& interrupt_effect_info );
    virtual ~InterruptEffectInfo();
    inline InterruptEffectInfo<T>& operator=( const InterruptEffectInfo<T>& interrupt_effect_info );
 
 // Private Functions
 private:
    
 // Public Static Functions
 public:
    
 };
 
 /** PROTECTED STATIC FUNCTIONS **/
 
 /**
  * process_interrupt_effect() applies the specified interrupt effect pointed to onto the specified object pointed to.
  * The effect_info_Ptr must be a pointer to a InterruptEffectInfo.
  *
  * @param (EffectInfo<T>*) effect_info_Ptr
  * @param (Object<T>*) into_object_Ptr
  * @param (const CollisionEntry&) c_entry
  */
 template <typename T>
 inline void InterruptEffectInfo<T>::process_interrupt_effect( EffectInfo<T>* effect_info_Ptr, Object<T>* into_object_Ptr, 
                                                               const CollisionEntry& c_entry )
 {  
    nassertv( effect_info_Ptr != NULL );
    nassertv( into_object_Ptr != NULL );
    
    into_object_Ptr->interrupt_action();
 }
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 InterruptEffectInfo<T>::InterruptEffectInfo( EffectFunc* effect_func )
                        : EffectInfo<T>( effect_func )
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 InterruptEffectInfo<T>::InterruptEffectInfo( const InterruptEffectInfo<T>& interrupt_effect_info )
                        : EffectInfo<T>( interrupt_effect_info )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 InterruptEffectInfo<T>::~InterruptEffectInfo()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified InterruptEffectInfo to this InterruptEffectInfo.
  *
  * @param (const InterruptEffectInfo<T>&) interrupt_effect_info
  * @return InterruptEffectInfo<T>&
  */
 template <typename T>
 inline InterruptEffectInfo<T>& InterruptEffectInfo<T>::operator=( const InterruptEffectInfo<T>& interrupt_effect_info )
 {
    EffectInfo<T>::operator=( interrupt_effect_info );
    
    return *this;
 }
 
 #endif // INTERRUPT_EFFECT_INFO_H